/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

function jchOnUserInteract(callback)
{
    window.addEventListener('load', function () {
        if (window.scrollY > 0) {
            callback();
        }
    }, {once: true, passive: true});

    const events = ['keydown', 'keyup', 'keypress', 'input', 'auxclick', 'click', 'dblclick',
        'mousedown', 'mouseup', /*'mouseover', 'mousemove', */'mouseout', 'mouseenter', 'mouseleave',
        'mousewheel', 'wheel', 'contextmenu',/* 'pointerover', 'pointerout', 'pointerenter', 'pointerleave',
        'pointerdown', 'pointerup', 'pointermove', 'pointercancel', 'gotpointercapture',
        'lostpointercapture', 'pointerrawupdate', */'touchstart', 'touchmove', 'touchend', 'touchcancel'];

    window.addEventListener('load', function () {
        events.forEach(function (e) {
            window.addEventListener(e, function () {
                callback();
            }, {once: true, passive: true});
        });
    });
}