<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

namespace JchOptimize\Core\Laminas;

use _JchOptimizeVendor\Joomla\DI\Container;
use JchOptimize\Core\Platform\PathsInterface;
use JchOptimize\Core\Registry;
use JchOptimize\Core\Service\Provider\LaminasCacheServices;
use JchOptimize\Service\Provider\Params;
use JchOptimize\Service\Provider\PlatformUtils;

class CacheConfigurationContainerFactory
{
    private static ?Container $container = null;
    public static function create(Registry $params, PathsInterface $paths): Container
    {
        if (self::$container === null) {
            self::$container = new Container();
            self::$container->registerServiceProvider(new LaminasCacheServices($params, $paths));
        }

        return self::$container;
    }
}
