<?php

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerScript;
use Joomla\Database\DatabaseDriver;
use Joomla\Database\ParameterType;

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

class Mod_JchsupportinfoInstallerScript extends InstallerScript
{
    protected $allowDowngrades = true;

    public function postflight(string $type)
    {
        if ($type == 'install' || $type == 'update') {
            $instances = $this->getInstances(true);

            if (!$this->deleteModules($instances)) {
                return false;
            }

            $module = [
                'asset_id' => 0,
                'language' => '*',
                'note' => '',
                'published' => 1,
                'module' => $this->extension,
                'showtitle' => 1,
                'access' => 1,
                'client_id' => 1,
                'position' => 'cpanel-com-jchoptimize-cpanel',
                'id' => 0,
                'title' => 'Support Info',
                'ordering' => 8,
                'params' => [
                    'header_icon' => 'none fa fa-ticket',
                    'context' => 'automatic',
                    'module_tag' => 'div',
                    'bootstrap_size' => '12',
                    'header_tag' => 'h2',
                    'header_class' => '',
                    'style' => '0'
                ]
            ];

            $moduleModel = Factory::getApplication()->bootComponent('com_modules')->getMVCFactory()
                ->createModel('Module', 'Administrator', ['ignore_request' => true]);

            if (!$moduleModel->save($module)) {
                Factory::getApplication()->enqueueMessage('Unable to install JCH Optimize Support Info module');
            }
        }
    }

    private function deleteModules(array $instances): bool
    {
        try {
            foreach ($instances as $pk) {
                $pk = (int)$pk;
                $db = Factory::getContainer()->get(DatabaseDriver::class);
                $query = $db->getQuery(true)
                    ->delete($db->quoteName('#__modules'))
                    ->where($db->quoteName('id') . ' = :id')
                    ->bind(':id', $pk, ParameterType::INTEGER);
                $db->setQuery($query);
                $db->execute();

                $this->deleteMenuAssignments($pk);
            }

            return true;
        } catch (Exception) {
            return false;
        }
    }

    private function deleteMenuAssignments(int $pk): void
    {
        $db = Factory::getContainer()->get(DatabaseDriver::class);
        $query = $db->getQuery(true)
            ->delete($db->quoteName('#__modules_menu'))
            ->where($db->quoteName('moduleid') . ' = :moduleid')
            ->bind(':moduleid', $pk, ParameterType::INTEGER);
        $db->setQuery($query);
        $db->execute();
    }
}
