<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/core
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use Joomla\DI\Container;
use Joomla\DI\ContainerAwareInterface;
use Joomla\DI\ContainerAwareTrait;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Filesystem\Exception\FilesystemException;
use Joomla\Filesystem\File;
use Joomla\Filesystem\Folder;
use Joomla\Filesystem\Path;
use Joomla\Input\Input;
use Joomla\Registry\Registry;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\ContainerInterface;
use Psr\Container\NotFoundExceptionInterface;

defined('_JEXEC') or die('Restricted Access');

if (!class_exists('_JchOptimizeVendor\Joomla\DI\Container', false)) {
    class_alias(Container::class, '\\_JchOptimizeVendor\\Joomla\\DI\\Container');
}

if (!interface_exists('_JchOptimizeVendor\Joomla\DI\ContainerAwareInterface', false)) {
    class_alias(ContainerAwareInterface::class, '\\_JchOptimizeVendor\\Joomla\\DI\\ContainerAwareInterface');
}

if (!trait_exists('_JchOptimizeVendor\Joomla\DI\ContainerAwareTrait', false)) {
    class_alias(ContainerAwareTrait::class, '\\_JchOptimizeVendor\\Joomla\\DI\\ContainerAwareTrait');
}

if (!interface_exists('_JchOptimizeVendor\Joomla\DI\ServiceProviderInterface', false)) {
    class_alias(ServiceProviderInterface::class, '\\_JchOptimizeVendor\\Joomla\\DI\\ServiceProviderInterface');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Input\Input', false)) {
    class_alias(Input::class, '\\_JchOptimizeVendor\\Joomla\\Input\\Input');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Filesystem\File', false)) {
    class_alias(File::class, '\\_JchOptimizeVendor\\Joomla\\Filesystem\\File');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Registry\Registry', false)) {
    class_alias(Registry::class, '\\_JchOptimizeVendor\\Joomla\\Registry\\Registry');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Filesystem\Folder', false)) {
    class_alias(Folder::class, '\\_JchOptimizeVendor\\Joomla\\Filesystem\\Folder');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Filesystem\Path', false)) {
    class_alias(Path::class, '\\_JchOptimizeVendor\\Joomla\\Filesystem\\Path');
}

if (!class_exists('_JchOptimizeVendor\Joomla\Filesystem\Exception\FilesystemException', false)) {
    class_alias(FilesystemException::class, '\\_JchOptimizeVendor\\Joomla\\Filesystem\\Exception\\FilesystemException');
}

if (!interface_exists('_JchOptimizeVendor\Psr\Container\ContainerInterface', false)) {
    class_alias(ContainerInterface::class, '\\_JchOptimizeVendor\\Psr\\Container\\ContainerInterface');
}

if (!interface_exists('_JchOptimizeVendor\Psr\Container\ContainerExceptionInterface', false)) {
    class_alias(
        ContainerExceptionInterface::class,
        '\\_JchOptimizeVendor\\Psr\\Container\\ContainerExceptionInterface'
    );
}

if (!interface_exists('_JchOptimizeVendor\Psr\Container\NotFoundExceptionInterface', false)) {
    class_alias(
        NotFoundExceptionInterface::class,
        '\\_JchOptimizeVendor\\Psr\\Container\\NotFoundExceptionInterface'
    );
}
