<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use JchOptimize\ContainerFactory;
use JchOptimize\Core\Platform\PathsInterface;
use JchOptimize\Core\SystemUri;
use Joomla\CMS\Form\FormField as JFormField;
use Joomla\CMS\Layout\LayoutHelper;

class JFormFieldCriticaljsconfigurehelper extends JFormField
{
    protected $type = 'criticaljsconfigurehelper';

    protected function getInput()
    {
        $modal = $this->getModalLayout();

        return <<<HTML
<div>
<button type="button" class="btn btn-primary" id="criticalJsModalLaunchButton">
Open
</button>
</div>
<style>
.modal{
--modal-width: 75% !important;
}
</style>
{$modal}
HTML;
    }

    private function getModalLayout(): string
    {
        $container = ContainerFactory::getContainer();
        $pathsUtils = $container->get(PathsInterface::class);
        $data = [
            'baseUrl' => SystemUri::siteBaseFull($pathsUtils),
            'loadingImageUrl' => $pathsUtils->mediaUrl() . '/core/images/loader.gif',
            'tableBodyAjaxUrl' => 'index.php?option=com_jchoptimize&view=CriticalJsTableBody',
            'autoSaveAjaxUrl' => 'index.php?option=com_jchoptimize&view=CriticalJsAutoSave&format=json'
        ];

        return LayoutHelper::render(
            'configure_helper.critical_js_joomla_layout',
            $data,
            _JCH_BASE_DIR . '/layouts'
        );
    }
}
