<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

include_once dirname(__FILE__) . '/exclude.php';

class JFormFieldExcludejspei extends JFormFieldExclude
{
    public $type = 'excludejspei';
    public string $filetype = 'js';
    public string $filegroup = 'file';
    protected string $valueType = 'url';

    protected string $option1 = 'ieo';

    protected string $option2 = 'dontmove';

    protected static int $incrementor = 0;

    protected function getInput(): string
    {
        $this->value = array_values($this->value);
        $i = 0;
        $nextIndex = count($this->value);

        [$optionObj1, $optionObj2] = $this->getOptionObjects();
        $inc1 = ++JFormFieldExcludejspei::$incrementor;
        $inc2 = ++JFormFieldExcludescriptspei::$incrementor;

        $field = <<<HTML
<script>let optionObj{$inc1} = $optionObj1; let optionObj{$inc2} = $optionObj2;</script>  
<fieldset id="fieldset-{$this->fieldname}" data-index="{$nextIndex}">
{$this->fieldHeader()}
HTML;

        foreach ($this->value as $value) {
            //Sanity check
            if (!isset($value[$this->valueType])) {
                $oldValue = $value;
                $value = [];
                $value[$this->valueType] = $oldValue;
            }

            $field .= $this->fieldSetChildren($i, $value);
            $i++;
        }

        $attributes = 'class="inputbox chzn-custom-value input-large jch-multiselect"  multiple data-jch_type="' . $this->filetype . '" data-jch_param="' . $this->fieldname . '" data-jch_group="' . $this->filegroup . '"';
        $select = HTMLHelper::_(
            'select.genericlist',
            $this->getOptions(),
            'jform[' . $this->fieldname . '][][' . $this->valueType . ']',
            $attributes,
            'id',
            'name',
            $this->value,
            $this->id
        );

        $uriRoot = Uri::root();

        $field .= <<<HTML
</fieldset>
<div id="div-{$this->fieldname}">{$select}
    <img id="img-{$this->fieldname}" class="jch-multiselect-loading-image" 
        src="{$uriRoot}media/com_jchoptimize/core/images/exclude-loader.gif" />

    <button type="button" class="btn btn-sm btn-secondary jch-multiselect-add-button" 
       onmousedown="jchMultiselect.addJchJsOption('jform_{$this->fieldname}', '{$this->fieldname}', '{$this->valueType}', optionObj{$inc1}, optionObj{$inc2})" style="display: none;">Add item</button>
</div>
<script>
jQuery('#jform_{$this->fieldname}').on('change', function(evt, params){
    jchMultiselect.appendJchJsOption(
        'jform_{$this->fieldname}',
        '{$this->fieldname}',
       params,
        '{$this->valueType}', 
        optionObj{$inc1},
        optionObj{$inc2}
    );
});
</script>
HTML;

        return $field;
    }

    protected function fieldHeader(): string
    {
        return <<<HTML
<div class="jch-js-fieldset-children jch-js-excludes-header">
<span class="jch-js-ieo-header">&nbsp;&nbsp;Ignore execution order&nbsp;&nbsp;&nbsp;</span>
<span class="jch-js-dontmove-header">&nbsp;&nbsp;&nbsp;Don't move to bottom&nbsp;&nbsp;</span>
</div>
HTML;
    }

    protected function fieldSetChildren($i, $value): string
    {
            $option1Checked = isset($value[$this->option1]) ? 'checked' : '';
            $option2Checked = isset($value[$this->option2]) ? 'checked' : '';
            $dataValue = $this->multiSelect->{'prepare' . ucfirst($this->filegroup) . 'Values'}(
                $value[$this->valueType]
            );
            $size = strlen($value[$this->valueType]);

        return <<<HTML
<div id="div-{$this->fieldname}-{$i}" class="jch-js-fieldset-children jch-js-excludes-container">
<span class="jch-js-excludes"><span><input type="text" readonly size="{$size}" value="{$value[$this->valueType]}" name="jform[{$this->fieldname}][$i][{$this->valueType}]"> 
{$dataValue}
<button type="button" class="jch-multiselect-remove-button" onmouseup="jchMultiselect.removeJchJsOption('div-{$this->fieldname}-{$i}', 'jform_{$this->fieldname}')"></button>
</span></span>
<span class="jch-js-ieo">
    <input type="checkbox" name="jform[{$this->fieldname}][$i][{$this->option1}]" {$option1Checked}/>
</span>
<span class="jch-js-dontmove">
    <input type="checkbox" name="jform[{$this->fieldname}][$i][{$this->option2}]" {$option2Checked} />
</span>
</div>
HTML;
    }

    protected function getOptions(): array
    {
        return [];
    }

    protected function getOptionObjects(): array
    {
        return [
            "{type: \"checkbox\", name: \"{$this->option1}\"}",
            "{type: \"checkbox\", name: \"{$this->option2}\"}"
        ];
    }
}
