<?php

namespace _JchOptimizeVendor\Laminas\EventManager;

/**
 * Interface for self-registering event listeners.
 *
 * Classes implementing this interface may be registered by name or instance
 * with an EventManager, without an event name. The {@link attach()} method will
 * then be called with the current EventManager instance, allowing the class to
 * wire up one or more listeners.
 */
interface ListenerAggregateInterface
{
    /**
     * Attach one or more listeners
     *
     * Implementors may add an optional $priority argument; the EventManager
     * implementation will pass this to the aggregate.
     *
     * @param int                   $priority
     * @return void
     */
    public function attach(EventManagerInterface $events, $priority = 1);
    /**
     * Detach all previously attached listeners
     *
     * @return void
     */
    public function detach(EventManagerInterface $events);
}
