<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 *  @package   jchoptimize/core
 *  @author    Samuel Marshall <samuel@jch-optimize.net>
 *  @copyright Copyright (c) 2024 Samuel Marshall / JCH Optimize
 *  @license   GNU/GPLv3, or later. See LICENSE file
 *
 *  If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use JchOptimize\Core\Admin\AdminHelper;
use JchOptimize\Core\FeatureHelpers\ResponsiveImages;

// phpcs:disable PSR1.Files.SideEffects
defined('_JEXEC') or die;
include_once dirname(__FILE__) . '/excludejspei.php';
// phpcs:enable PSR1.Files.SideEffects

class JFormFieldCropgravity extends JFormFieldExcludejspei
{
    public $type = 'cropgravity';
    public string $filetype = 'lazyload';
    public string $filegroup = 'file';
    protected string $option1 = 'gravity';
    protected string $option2 = 'cropwidth';

    protected function fieldHeader(): string
    {
        return <<<HTML
<div class="jch-js-fieldset-children jch-js-excludes-header">
<span class="jch-js-ieo-header">&nbsp;&nbsp;&nbsp;&nbsp;Position&nbsp;&nbsp;&nbsp;</span>
<span class="jch-js-dontmove-header">&nbsp;&nbsp;&nbsp;Width (px)&nbsp;&nbsp;</span>
</div>
HTML;
    }

    protected function fieldSetChildren($i, $value): string
    {
        $option1Value = $value[$this->option1] ?? 'Center';
        $option1WestSelected = $option1Value == 'West' ? 'selected' : '';
        $option1CenterSelected = $option1Value == 'Center' ? 'selected' : '';
        $option1EastSelected = $option1Value == 'East' ? 'selected' : '';
        $option2Value = $value[$this->option2] ?? ResponsiveImages::$breakpoints[0];
        $dataValue = $this->multiSelect->{'prepare' . ucfirst($this->filegroup) . 'Values'}(
            $value[$this->valueType]
        );
        $size = strlen($value[$this->valueType]);

        return <<<HTML
<div id="div-{$this->fieldname}-{$i}" class="jch-js-fieldset-children jch-js-excludes-container">
<span class="jch-js-excludes"><span>
<input type="text" readonly size="{$size}" value="{$value[$this->valueType]}" 
    name="jform[{$this->fieldname}][$i][{$this->valueType}]"> 
{$dataValue}
<button type="button" class="jch-multiselect-remove-button" 
    onmouseup="jchMultiselect.removeJchJsOption('div-{$this->fieldname}-{$i}', 'jform_{$this->fieldname}')"></button>
</span></span>
<span class="jch-js-ieo has-select">
    <select name="jform[{$this->fieldname}][$i][{$this->option1}]">
        <option value="West" $option1WestSelected>Left</option>
        <option value="Center" $option1CenterSelected>Center</option>
        <option value="East" $option1EastSelected>Right</option>
    </select>
</span>
<span class="jch-js-dontmove has-text-input">
    <input type="text" name="jform[{$this->fieldname}][$i][{$this->option2}]" value="{$option2Value}"  />
</span>
</div>
HTML;
    }

    protected function getOptionObjects(): array
    {
        $breakpoint = ResponsiveImages::$breakpoints[0];

        return [
            "{
                type: \"select\", 
                name: \"{$this->option1}\", 
                htmlOptions: [
                    {value: \"West\", selected: \"\", text: \"Left\"},
                    {value: \"Center\", selected: \"selected\", text: \"Center\"},
                    {value: \"East\", selected: \"\", text: \"Right\"}
                ]
            }",
            "{type: \"text\", name: \"{$this->option2}\", defaultValue: \"$breakpoint\"}"
        ];
    }

       protected function getInput(): string
    {
        if (!JCH_PRO) {
            return AdminHelper::proOnlyField();
        } else {
            return parent::getInput();
        }
    }
}
